const months = [
  "January",
  "February",
  "March",
  "April",
  "May",
  "June",
  "July",
  "August",
  "September",
  "October",
  "November",
  "December",
];


function gotoDate() {
    let date=new Date(document.querySelector(".date-input").value);
    if (document.querySelector(".date-input").value.split("-").length == 3) {
		initCalendar(document.querySelector(".date-input").valueAsDate);
		return;
	}
	alert("Invalid Date");
}

function nextMonth(step) {
    let date=new Date(document.querySelector(".date-input").value);
    date=new Date(date.getFullYear(),date.getMonth()+step,1)
	initCalendar(date);
}

function toDay() {
	initCalendar(new Date());
}

function getActiveDay(date) {
	document.querySelector(".event-day").innerHTML = date.toString().split(" ")[0];
	document.querySelector(".event-date").innerHTML =` ${date.getDate()}  ${months[date.getMonth()]}  ${date.getFullYear()}`;
	document.querySelector(".date-input").value=date.toLocaleDateString('en-CA');
}

function showEvent(element){
    let date=new Date(element.id);
	getActiveDay(date);

	//remove active
	document.querySelectorAll(".day").forEach((day) => {
		day.classList.remove("active");
	});
	element.classList.add("active");
	updateEvents(date);
}

//function update events when a day is active
function updateEvents(date) {
    document.querySelector(".events").innerHTML ="";
	fetch(`php/?d=${date.toLocaleDateString('en-CA')}`)
		.then((data)=>data.json())
		.then((events)=>{
			if (events.length<1) {
				document.querySelector(".events").innerHTML = `
				<div class="no-event">
					<h3>No Events</h3>
				</div>`;
			}else{
				events.forEach((event) => {
				    document.querySelector(".events").innerHTML += `
				<div id="${event.id}"  class="event">
					<div class="title">
						<i class="fas fa-circle"></i>
							<h3 class="event-title">${event.Event_name}</h3>
					</div>
					<div class="event-time">
						<span class="event-time">${event.EventTimeFrom}</span>
					</div>
					<div class="event-time">
						<span class="event-time">${event.EventTimeTo}</span>
					</div>
				</div>
				    `;
			});
		    document.querySelectorAll(".event").forEach((day) => {
	    	day.addEventListener(
             "click",
	         (e) => {
	             alert(e.target.id);
             }
        );

	});
}
});
}

function addEvent(){
  const eventTitle = document.querySelector(".event-name ").value;
  const eventTimeFrom = document.querySelector(".event-time-from ").value;
  const eventTimeTo = document.querySelector(".event-time-to ").value;
  if (eventTitle === "" || eventTimeFrom === "" || eventTimeTo === "") {
    alert("Please fill all the fields");
  }else{
    let date=new Date(document.querySelector(".date-input").value);
    alert(date);
    let fd=new FormData();
    fd.set('eventTitle',eventTitle);
    fd.set('eventTimeFrom',eventTimeFrom);
    fd.set('eventTimeTo',eventTimeTo);
    fd.set('date',date.toLocaleDateString('en-CA').toString());
    fetch('php/index.php'
        ,{
        method: "POST",
        body: fd
        }
        )
	    .then((response) => response.text())
        .then((res)=>{alert(res)
        document.querySelector(".event-name ").value="";
        document.querySelector(".event-time-from ").value="";
        document.querySelector(".event-time-to ").value="";
  });
    	updateEvents(date) ;
  	    document.querySelector(".add-event-wrapper ").classList.remove("active");
  	    
  }
}

//function to add days in days with class day and prev-date next-date on previous month and next month days and active on today
function init() {
    document.querySelector(".goto-btn").addEventListener("click", gotoDate);
    document.querySelector(".prev").addEventListener("click", function(){nextMonth(-1)});
    document.querySelector(".next").addEventListener("click", function(){nextMonth(1)});
    document.querySelector(".today-btn").addEventListener("click", toDay);
    document.querySelector(".add-event").addEventListener("click", () => {
    document.querySelector(".add-event-wrapper ").classList.toggle("active");
    });
    document.querySelector(".close ").addEventListener("click", () => {
        document.querySelector(".add-event-wrapper ").classList.remove("active");
    });
    document.querySelector(".add-event-btn ").addEventListener("click", addEvent);
    initCalendar(new Date()) ;
}

function initCalendar(date) {
    document.querySelector(".date-input").value=date.toLocaleDateString('en-CA');
    const firstDay=new Date(date.getFullYear(),date.getMonth(),1);
    const lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
    const prevLastDay = new Date(date.getFullYear(), date.getMonth(), 0);
    const prevDays = prevLastDay.getDate();
    const lastDate = lastDay.getDate();
    const day = firstDay.getDay();
    const nextDays = 7 - lastDay.getDay() - 1;

    //Change title
    document.querySelector(".date").innerHTML =`${months[date.getMonth()]} ${date.getFullYear()}`;

    let days = "";
    for (let x =0; x < firstDay.getDay(); x++) {
        let text = prevLastDay.toLocaleString().split(",");
        days = `<div id="${text[0]}" class="day prev-date">${prevLastDay.getDate()}</div>`+days;
        prevLastDay.setDate(prevLastDay.getDate() - 1); 
    }
  for (let i = 1; i <= lastDate; i++) {
        firstDay.setDate(firstDay.getDate() + 1); 
        let text = firstDay.toLocaleString().split(",");
        let active=((date.toLocaleDateString() === firstDay.toLocaleDateString())?"active":"");
        days += `<div id="${text[0]}" class="day ${active}">${firstDay.getDate()}</div>`;
    }
    for (let j = 1; j <= nextDays; j++) {
        lastDay.setDate(lastDay.getDate() + 1); 
        let text = lastDay.toLocaleString().split(",");
        days+= `<div id="${text[0]}" class="day next-date">${lastDay.getDate()}</div>`;

    }


    document.querySelector(".days").innerHTML = days;
    getActiveDay(date);
    updateEvents(date);
    
    //class day addAction    
    document.querySelectorAll(".day").forEach((day) => {
	    day.addEventListener(
            "click",
	        (e) => {
	            showEvent(e.target)
            }
        );
    });
}